;=======================================================================
cstrcat: ; R0 - dest, DPTR - src (command memory) 
    mov A,@R0
    inc R0
    jnz cstrcat
    dec R0
;-----------------------------------------------------------------------
cstrcpy: ; R0 - dest, DPTR - src (command memory)
    clr  A
    movc A,@A+DPTR
    mov  @R0,A
    jz   .done
    inc  DPTR
    inc  R0
    jmp  cstrcpy
.done:
    ret 
;-----------------------------------------------------------------------
strcat: ; R0 - dest, R1 - src 
    mov A,@R0
    inc R0
    jnz strcat
    dec R0
;-----------------------------------------------------------------------
strcpy: ; R0 - dest, R1 - src
    mov  A,@R1
    mov  @R0,A
    jz   .done
    inc  R1
    inc  R0
    jmp  strcpy
.done:
    ret 
;-----------------------------------------------------------------------
byte2hex: ; A -> BA
    mov  B,A
    swap A
    anl  A,#15
    call .hex
    xch  A,B
    anl  A,#15
.hex:
    inc  A
    movc A,@A+PC
    ret   
    db "0123456789ABCDEF" 
;-----------------------------------------------------------------------
hex2bin: ; BA -> A
    push B
    call .nibble
    pop  B
    jc   .ex
    xch  A,B
    push B
    call .nibble
    pop  B
    jc   .ex
    swap A
    orl  A,B
.ex:
    ret
;-----------------------------------------------------------------------
.nibble:
    call uchar
    clr  C
    subb A,#30h
    jc   .done
    mov  B,A
    subb A,#10
    mov  A,B
    jc   .ok
    subb A,#'A'-30h
    jc   .done
    mov  B,A
    subb A,#6
    mov  A,B
    cpl  C
    jc   .done
    add  A,#10    
.ok:
    clr  C        
.done:
    ret
;-----------------------------------------------------------------------
uchar: ; A -> uppercase A, XB
    mov  B,A
    add  A,#255-'z'
    mov  A,B
    jc   .out
    add  A,#256-'a'
    mov  A,B
    jnc  .out
    add  A,#'A'-'a'
.out:
    ret
;-----------------------------------------------------------------------
lchar: ; A -> lowercase A, XB
    mov  B,A
    add  A,#255-'Z'
    mov  A,B
    jc   .out
    add  A,#256-'A'
    mov  A,B
    jnc  .out
    add  A,#'a'-'A'
.out:
    ret
;-----------------------------------------------------------------------
char2num: ; A -> A, XB, CARRY ON if fail  
    mov  B,A
    add  A,#255-'9'
    mov  A,B
    jc   .out
    add  A,#256-'0'
    mov  A,B
    cpl  C
    jc   .out
    subb A,#'0'
.out:
    ret
;-----------------------------------------------------------------------
; R0=start -> R0=finish, R4(LSB)-R7(MSB)=unsigned_number
; XA,B,R3
; empty string - returns error
; string starts with non-hex character - returns error
; 32-bit overflow - returns error
; on success R0 points to the first not processed character
;-----------------------------------------------------------------------
a2h:
    mov  A,@R0 
    jz   .error ; empty string
    
    call hex2bin.nibble
    jc   .done ; no any digit character

    mov  R4,A
    clr  A
    mov  R5,A
    mov  R6,A
    mov  R7,A

.loop:
    inc  R0
    mov  A,@R0
    clr  C
    jz   .done ; end of string reached
    
    call hex2bin.nibble
    cpl  C
    jnc  .done ; first non-digit character met
    
    mov  R3,A
    mov  A,R4
    swap A
    mov  B,A
    anl  A,#0xF0
    orl  A,R3
    mov  R4,A
    
    mov  A,B
    anl  A,#15
    mov  R3,A
    mov  A,R5
    swap A
    mov  B,A
    anl  A,#0xF0
    orl  A,R3
    mov  R5,A
    
    mov  A,B
    anl  A,#15
    mov  R3,A
    mov  A,R6
    swap A
    mov  B,A
    anl  A,#0xF0
    orl  A,R3
    mov  R6,A
    
    mov  A,B
    anl  A,#15
    mov  R3,A
    mov  A,R7
    swap A
    mov  B,A
    anl  A,#0xF0
    orl  A,R3
    mov  R7,A
    
    mov  A,B
    anl  A,#15
    jz   .loop ; otherwise: overflow

.error:
    setb C
.done:
    ret    
;-----------------------------------------------------------------------
; R0=start -> R0=finish, R4(LSB)-R7(MSB)=unsigned_number
; XA,B,R1,R2,R3
; empty string - returns error
; string starts with non-numeric character - returns error
; 32-bit overflow - returns error
; on success R0 points to the first not processed character
;-----------------------------------------------------------------------
a2u: 
    mov  A,@R0 
    jz   .error ; empty string
    
    call char2num
    jc   .done ; no any digit character

    mov  R4,A
    clr  A
    mov  R5,A
    mov  R6,A
    mov  R7,A

.loop:
    inc  R0
    mov  A,@R0
    clr  C
    jz   .done ; end of string reached
    
    call char2num
    cpl  C
    jnc  .done ; first non-digit character met
    
    mov  R1,A

    mov  A,R4
    mov  B,#10
    mul  AB
    mov  R4,A
    mov  R3,B
    
    mov  A,R5
    mov  B,#10
    mul  AB
    add  A,R3
    mov  R5,A
    mov  A,B
    addc A,#0
    mov  R3,A
    
    mov  A,R6
    mov  B,#10
    mul  AB
    add  A,R3
    mov  R6,A
    mov  A,B
    addc A,#0
    mov  R3,A
    
    mov  A,R7
    mov  B,#10
    mul  AB
    add  A,R3
    mov  R7,A
    jc   .done  ; overflow
    mov  A,B
    jnz  .error ; overflow
    
    mov  A,R1 
    
    add  A,R4
    mov  R4,A
    jnc  .loop
    inc  R5
    cjne R5,#0,.loop
    inc  R6
    cjne R6,#0,.loop
    inc  R7
    cjne R7,#0,.loop
.error:
    setb C
.done:
    ret    
;=======================================================================
;
;=======================================================================
; R4(LSB)-R7(MSB)=unsigned_number
; in: R0 -> last char of the buffer (at least 10 characters for chars)
; out: R0 -> first char of number string
;-----------------------------------------------------------------------
u2a:

    inc  R0
.loop:
    dec  R0
    
    mov  A,R7
    mov  B,#0
    jz   .m7

    mov  B,#10
    div  AB
    mov  R7,A

    xch  A,B
    swap A
    xch  A,B

.m7:
    mov  R1,A
    mov  A,R6
    
    anl  A,#0xF0
    swap A
    orl  A,B
    mov  B,#10
    div  AB

    xch  A,B
    swap A
    xch  A,B
    
    swap A
    mov  R2,A
    
    mov  A,R6
    anl  A,#0x0F
    orl  A,B
    mov  B,#10
    div  AB

    xch  A,B
    swap A
    xch  A,B

    orl  A,R2
    mov  R6,A
    orl  A,R1
    mov  R1,A
    
    mov  A,R5
    
    anl  A,#0xF0
    swap A
    orl  A,B
    mov  B,#10
    div  AB

    xch  A,B
    swap A
    xch  A,B
    
    swap A
    mov  R2,A
    
    mov  A,R5
    anl  A,#0x0F
    orl  A,B
    mov  B,#10
    div  AB

    xch  A,B
    swap A
    xch  A,B

    orl  A,R2
    mov  R5,A
    orl  A,R1
    mov  R1,A
    
    mov  A,R4
    
    anl  A,#0xF0
    swap A
    orl  A,B
    mov  B,#10
    div  AB

    xch  A,B
    swap A
    xch  A,B
    
    swap A
    mov  R2,A
    
    mov  A,R4
    anl  A,#0x0F
    orl  A,B
    mov  B,#10
    div  AB

    orl  A,R2
    mov  R4,A
    orl  A,R1
    mov  R1,A
    
    xch  A,B
    call byte2hex
    mov  @R0,A
    
    cjne R1,#0,.loop
    
    ret
;-----------------------------------------------------------------------
    
    