;=======================================================================
;    - 24
;-----------------------------------------------------------------------
; P1: LED DISPLAY, 4 BUTTONS & SWITCH
; BANK0 & TIMER0 are using by rtc 
;=======================================================================
;include "hex.inc"
include "8051x.inc"
include "max7219.inc"
include "listing.inc"
;=======================================================================
LED  equ P3.7
BUT  equ P2.7
;-----------------------------------------------------------------------
SW   equ SPI_DIN
;-----------------------------------------------------------------------
BUT0 equ 1; P1.0
BUT1 equ 2; P1.1
BUT2 equ 4; P1.2
BUT3 equ 8; P1.3
;-----------------------------------------------------------------------
B_SEC   equ BUT1
B_MIN   equ BUT2
B_HOUR  equ BUT3
;-----------------------------------------------------------------------
DIG_NUM=8
DATA NUMS,DIG_NUM
DATA KEYS
;-----------------------------------------------------------------------
FLAG TEN_MS
FLAG EDIT
;-----------------------------------------------------------------------
RAM_START = 2000h
;-----------------------------------------------------------------------
    org RAM_START
;-----------------------------------------------------------------------
    jmp start
;-----------------------------------------------------------------------
;    orgx 0003h+RAM_START,-1 ; INT0
;    reti
;-----------------------------------------------------------------------
    orgx 000Bh+RAM_START,-1 ; TF0
    jmp scan
;-----------------------------------------------------------------------
;    orgx 0013h+RAM_START,-1 ; INT1
;    reti
;-----------------------------------------------------------------------
;    orgx 001Bh+RAM_START,-1 ; TF1
;    reti    
;-----------------------------------------------------------------------
;    orgx 0023h+RAM_START,-1 ; TI & RI
;    reti
;-----------------------------------------------------------------------
;    orgx 002Bh+RAM_START,-1 ; TF2 & EXF2
;    reti
;=======================================================================
include "spi.inc"
;=======================================================================
;
;=======================================================================
num2led: ; A = 0..15 -> A = 7 segment LED combination
    anl  A,#0Fh
    inc  A
    movc A,@A+PC
    ret
    db DIG_0,DIG_1,DIG_2,DIG_3,DIG_4,DIG_5,DIG_6,DIG_7    
    db DIG_8,DIG_9,DIG_A,DIG_B,DIG_C,DIG_D,DIG_E,DIG_F    
;-----------------------------------------------------------------------
show_sym: ; A - symbol, B - place (0..7)
    xch  A,B 
    add  A,#MAX7219_DIGIT0
    jmp  spi16_send
;-----------------------------------------------------------------------
show_row: ; R0->row start (leftmost symbol); R0,R1,A,B - destroyed
    mov  R1,#DIG_NUM
.loop:
    mov  B,R1
    dec  B
    mov  A,@R0
    call show_sym
    inc  R0
    djnz R1,.loop
    ret    
;-----------------------------------------------------------------------
cls: ; R0 destroyed
    push ACC
    push B
    mov  R0,#MAX7219_DIGIT0
.loop:
    clr  B
    mov  A,R0
    call spi16_send
    inc  R0
    cjne R0,#MAX7219_DIGIT7+1,.loop
    pop  B
    pop  ACC
    ret
;-----------------------------------------------------------------------
screen_init:
    mov  DPTR,#.data
.loop:
    clr  A
    movc A,@A+DPTR
    inc  DPTR
    jz   cls
    mov  B,A
    clr  A
    movc A,@A+DPTR
    inc  DPTR
    xch  A,B
    call spi16_send
    jmp  .loop
.data:
    db MAX7219_TEST,0
    db MAX7219_DECODEMODE,0
    db MAX7219_SCANLIMIT,7
    db MAX7219_INTENSITY,3
    db MAX7219_SHUTDOWN,1
    db 0
;=======================================================================
;
;=======================================================================
;   1 ms : 2000 ticks @ 24 MHz : 24000000 / ( 12 * 1000 )
;-----------------------------------------------------------------------
ONE_MS = -2000 + 11 ; 11 ticks between stop and start timer 0 again
;-----------------------------------------------------------------------
;   R3 - ms counter
;-----------------------------------------------------------------------
scan:
;-----------------------------------------------------------------------
    clr  TR0
;-----------------------------------------------------------------------
    push PSW                     ; 2
    push ACC                     ; 2
;-----------------------------------------------------------------------
    mov  A,TL0                   ; 1
    add  A,#255 and ONE_MS       ; 1
    mov  TL0,A                   ; 1
    mov  A,TH0                   ; 1
    addc A,#255 and ONE_MS shr 8 ; 1
    mov  TH0,A                   ; 1
;-----------------------------------------------------------------------
    setb TR0                     ; 1
;-----------------------------------------------------------------------
    SELECT_BANK 0
;-----------------------------------------------------------------------
    djnz R3,.scan_ok
    mov  R3,#10
    mov  KEYS,P1
    setb TEN_MS
;-----------------------------------------------------------------------
.scan_ok:
    pop  ACC
    pop  PSW
;-----------------------------------------------------------------------
    reti
;=======================================================================
;
;=======================================================================
start:
;-----------------------------------------------------------------------
    SELECT_BANK 0
    mov  SP,#3Fh
;-----------------------------------------------------------------------
    mov  R3,#1
;-----------------------------------------------------------------------
    mov  TH0,#-1
    mov  TL0,#-1
;-----------------------------------------------------------------------
    mov  TMOD,#00010001b
    setb ET0
    setb EA
    setb TR0
;-----------------------------------------------------------------------
    SELECT_BANK 1
;-----------------------------------------------------------------------
    call time_reset
    call screen_init
    call time_show
    clr  TEN_MS
;-----------------------------------------------------------------------
KEY_DELAY = 25
;-----------------------------------------------------------------------
;    R3 - key delay
;    R4 - 10ms
;    R5 - s
;    R6 - m
;    R7 - h
;-----------------------------------------------------------------------
mainloop:
;-----------------------------------------------------------------------
    mov  A,KEYS
    anl  A,#B_SEC
    jnz  .b_1
    call sec_reset
    call time_show
.b_1:
;-----------------------------------------------------------------------
    cjne R3,#0,.dumb
;-----------------------------------------------------------------------
    mov  A,KEYS
    anl  A,#B_MIN
    jnz  .b_2
    setb C
    call min_inc
    call time_show
    mov  R3,#KEY_DELAY
.b_2:    
    mov  A,KEYS
    anl  A,#B_HOUR
    jnz  .b_3
    setb C
    call hour_inc
    call time_show
    mov  R3,#KEY_DELAY
.b_3:
;-----------------------------------------------------------------------
.dumb:
    jnb  TEN_MS,mainloop
    clr  TEN_MS
    mov  A,R3
    jz   .key_delay
    dec  R3
.key_delay:    
    djnz R4,mainloop
    mov  R4,#100
;-----------------------------------------------------------------------
    call time_inc
    call time_show
    jmp  mainloop
;-----------------------------------------------------------------------
time_reset:
    clr  A
    mov  R7,A
    mov  R6,A
    mov  R5,A
    mov  R4,#100
    ret
;-----------------------------------------------------------------------
time_inc:
    mov  A,R5
    add  A,#1
    da   A
    mov  R5,A
    add  A,#-60h
    jnz  .sec_ok
    mov  R5,#0
.sec_ok:
;-----------------------------------------------------------------------
    mov  A,KEYS
    anl  A,#B_MIN
    jz   .done
    call min_inc
;-----------------------------------------------------------------------
    mov  A,KEYS
    anl  A,#B_HOUR
    jz   .done
    call hour_inc
;-----------------------------------------------------------------------
.done:
    ret    
;-----------------------------------------------------------------------
sec_reset:
    mov  R5,#0
    mov  R4,#100
    clr  TEN_MS
    ret
;-----------------------------------------------------------------------
min_inc:  ; MIN + C
    mov  A,R6
    addc A,#0
    da   A
    mov  R6,A
    add  A,#-60h
    jnz  .ok
    mov  R6,#0
.ok:
    ret
;-----------------------------------------------------------------------
hour_inc: ; HOUR + C
    mov  A,R7
    addc A,#0
    da   A
    mov  R7,A
    add  A,#-24h
    jnz  .ok
    mov  R7,#0
.ok:
    ret    
;-----------------------------------------------------------------------
show_bcd: 
    push ACC
    swap A
    call num2led
    mov  @R0,A
    inc  R0    
    pop  ACC
    call num2led
    mov  @R0,A
    inc  R0 
    ret
;-----------------------------------------------------------------------
time_show:
    mov  R0,#NUMS
    mov  A,R7
    call show_bcd
;-----------------------------------------------------------------------
    mov  @R0,#SEG_G
    inc  R0
;-----------------------------------------------------------------------
    mov  A,R6
    call show_bcd
;-----------------------------------------------------------------------
    mov  @R0,#SEG_G
    inc  R0
;-----------------------------------------------------------------------
    mov  A,R5
    call show_bcd
;-----------------------------------------------------------------------
    mov  R0,#NUMS
    jmp  show_row
;=======================================================================
    
 