;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; -=   www.8052.com =- 
;-----------------------------------------------------------------------
; Convert 24-bit binary to 4-byte BCD format
; It uses Gorner algorithm:
; Num10=(...((0+bitn-1)*2+bitn-2)*2+...bit1)*2+bit0 
; INPUT  : (MSB)R1/R2/R3(LSB)    - bin24
; OUTPUT : (MSB)R4/R5/R6/R7(LSB) - bcd4
; MODIFY : R0,ACC,PSW and destroys bin24
; CODE size: 59 bytes
; TIME: 689...1073(max) machine cycles
; NOTE: no zero check implemented 
 
SUB_BIN24TOBCD4:
; prepare result area
	MOV	R4,#0
	MOV	R5,#0
	MOV	R6,#0
	MOV	R7,#0
	MOV	R0,#24				; number of bits
	AJMP	SUB_BIN24TOBCD4_0
SUB_BIN24TOBCD4_C:
; multiple BCD4 by 2
	MOV	A,R7
	ADD	A,R7
	DA	A
	MOV	R7,A
	MOV	A,R6
	ADDC	A,R6
	DA	A
	MOV	R6,A
	MOV	A,R5
	ADDC	A,R5
	DA	A
	MOV	R5,A
	MOV	A,R4
	ADDC	A,R4
	DA	A
	MOV	R4,A
SUB_BIN24TOBCD4_0:
; roll left bin24
	MOV	A,R3
	RLC	A
	MOV	R3,A
	MOV	A,R2
	RLC	A
	MOV	R2,A
	MOV	A,R1
	RLC	A
	MOV	R1,A
	JNC	SUB_BIN24TOBCD4_1		; bit=0
; bit=1 so increment BCD4 by 1
	MOV	A,#1
	ADD	A,R7
	DA	A
	MOV	R7,A
	CLR	A
	ADDC	A,R6
	DA	A
	MOV	R6,A
	CLR	A
	ADDC	A,R5
	DA	A
	MOV	R5,A
	CLR	A
	ADDC	A,R4
	DA	A
	MOV	R4,A
SUB_BIN24TOBCD4_1:
	DJNZ	R0,SUB_BIN24TOBCD4_C
	RET
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
