;=======================================================================
;    - 24
;=======================================================================
; BANK0 & TIMER0 are using by rtc 
;-----------------------------------------------------------------------
; P3: ISP
;=======================================================================
;include "hex.inc"
include "8051x.inc"
;include "listing.inc"
;=======================================================================
LED  equ P3.7
BUT  equ P2.7
;-----------------------------------------------------------------------
BUT0 equ P1.0
BUT1 equ P1.1
BUT2 equ P1.2
BUT3 equ P1.3
;-----------------------------------------------------------------------
FLAG TEN_MS
FLAG ONE_MS
;-----------------------------------------------------------------------
RAM_START = 2000h
;-----------------------------------------------------------------------
    org RAM_START
;-----------------------------------------------------------------------
    jmp start
;-----------------------------------------------------------------------
;    orgx 0003h+RAM_START,-1 ; INT0
;    reti
;-----------------------------------------------------------------------
    orgx 000Bh+RAM_START,-1 ; TF0
    jmp scan
;-----------------------------------------------------------------------
;    orgx 0013h+RAM_START,-1 ; INT1
;    reti
;-----------------------------------------------------------------------
;    orgx 001Bh+RAM_START,-1 ; TF1
;    reti    
;-----------------------------------------------------------------------
;    orgx 0023h+RAM_START,-1 ; TI & RI
;    reti
;-----------------------------------------------------------------------
;    orgx 002Bh+RAM_START,-1 ; TF2 & EXF2
;    reti
;=======================================================================
;
;=======================================================================
;   1 ms : 2000 ticks @ 24 MHz : 24000000 / ( 12 * 1000 )
;-----------------------------------------------------------------------
MS_ONE = -2000 + 11 ; 11 ticks between stop and start timer 0 again
;-----------------------------------------------------------------------
;   R3 - ms counter
;-----------------------------------------------------------------------
scan:
;-----------------------------------------------------------------------
    clr  TR0
;-----------------------------------------------------------------------
    push PSW                     ; 2
    push ACC                     ; 2
;-----------------------------------------------------------------------
    mov  A,TL0                   ; 1
    add  A,#255 and MS_ONE       ; 1
    mov  TL0,A                   ; 1
    mov  A,TH0                   ; 1
    addc A,#255 and MS_ONE shr 8 ; 1
    mov  TH0,A                   ; 1
;-----------------------------------------------------------------------
    setb TR0                     ; 1
;-----------------------------------------------------------------------
    SELECT_BANK 0
;-----------------------------------------------------------------------
    setb ONE_MS
    djnz R3,.scan_ok
    mov  R3,#10
    setb TEN_MS
;-----------------------------------------------------------------------
.scan_ok:
    pop  ACC
    pop  PSW
;-----------------------------------------------------------------------
    reti
;=======================================================================
;
;=======================================================================
start:
;-----------------------------------------------------------------------
    SELECT_BANK 0
    mov  SP,#STACK
;-----------------------------------------------------------------------
    mov  R3,#1
;-----------------------------------------------------------------------
    mov  TH0,#-1
    mov  TL0,#-1
;-----------------------------------------------------------------------
    mov  SCON,#50h
    mov  TH1,#0F3h
    mov  TMOD,#00100001b
    orl  PCON,#80h
    clr  TI
    clr  RI
    setb ET0
    setb EA
    setb TR0
    setb TR1
;-----------------------------------------------------------------------
    SELECT_BANK 1
;-----------------------------------------------------------------------
    call isp51.release
    mov  DPTR,#buffer
;-----------------------------------------------------------------------
ready: ; led: long on & short off 
    mov  R0,#100
    clr  LED
.delayA: 
    clr  TEN_MS   
.testA:
    jb   RI,sync
    jnb  TEN_MS,.testA
    djnz R0,.delayA
    mov  R0,#5
    setb LED
.delayB: 
    clr  TEN_MS  
.testB:     
    jb   RI,sync
    jnb  TEN_MS,.testB
    djnz R0,.delayB
    jmp  ready
;-----------------------------------------------------------------------
sync:
    mov  A,SBUF
    clr  RI
    jnz  ready
    setb LED
.zero:
    call read_byte
    jz   .zero
    cjne A,#0E6h,ready
;-----------------------------------------------------------------------
    call read_byte
    mov   R6,A
    mov   R4,A
;-----------------------------------------------------------------------
    call read_byte
    mov   R7,A
    mov   R5,A
    inc   R7
;-----------------------------------------------------------------------
    orl   A,R6
    jz    ok ; zero length image
;-----------------------------------------------------------------------
loading:
    call  read_byte
    movx  @DPTR,A
    inc   DPTR
    djnz  R6,loading 
    djnz  R7,loading
;-----------------------------------------------------------------------
    clr  LED
    mov  DPTR,#buffer
;-----------------------------------------------------------------------
    call isp51.prog_enable
    jnz  error
    call isp51.erase
    call isp51.writex
    jnz  error
;    jmp  ok
;=======================================================================
ok:   ; led: long on & same long off
    mov  A,#100
    mov  B,#100
    jmp  finish
;-----------------------------------------------------------------------
error: ; led: short on & long off
    mov  A,#5
    mov  B,#50
;-----------------------------------------------------------------------
finish:  ; A:LED ON, B:LED OFF (1..256) x 10 ms 
;-----------------------------------------------------------------------
    call isp51.release
.loop:
    mov  R0,A
    clr  LED
.delayA: 
    clr  TEN_MS   
    jnb  TEN_MS,$
    djnz R0,.delayA
;-----------------------------------------------------------------------
    mov  R0,B
.delayB:
    setb LED
    clr  TEN_MS
    jnb  TEN_MS,$
    djnz R0,.delayB
;-----------------------------------------------------------------------
    jmp  .loop
;-----------------------------------------------------------------------
read_byte:
    jnb  RI,$
    mov  A,SBUF
    clr  RI
    ret
;=======================================================================
;
;=======================================================================
include "spi-s51.inc"
;=======================================================================
;
;=======================================================================
buffer:
;=======================================================================
