#include <windows.h>
#include <winbase.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
//#include <sys/io.h>
#include <sys/types.h>
#include <fcntl.h>

#define LP_DATA   0x378
#define LP_STATUS 0x379
#define LP_CTRL   0x37A

#define SCK  0x10 /* DATA */
#define MOSI 0x20 /* DATA */
#define MISO 0x40 /* STATUS */
#define MASK 0b11001111

  typedef void	(_stdcall *OUT32)(short PortAddress, short data);
  typedef short	(_stdcall *INP32)(short PortAddress);

  HINSTANCE hLib;
  OUT32 Out32;
  INP32 Inp32;

void outb(short data,short PortAddress) {(Out32)(PortAddress,data);}
short inb(short PortAddress) {return (Inp32)(PortAddress);}

  FILE*  image;
  int    tem,fsize=0;
  char*  fname=0;
  char   readb;

void waitsync(char miso) {
  Sleep(100);
  if ((inb(LP_STATUS) & MISO)!=miso) {
   	outb(255, LP_DATA);
    FreeLibrary(hLib);
    //ioperm(LP_DATA, 3, 0);
    perror("\nError: device is not responding!\n");
    fclose(image);
    exit(1);
  }
}

void syncbit(char data) {
  char mosi;
  if (data) mosi=MOSI;
  else mosi=0;
  //printf("%i\n",data);

  waitsync(MISO);
  outb(MASK|0  |mosi,LP_DATA);
  waitsync(0);
  outb(MASK|SCK|mosi,LP_DATA);
}

void userexit() {
  outb(255, LP_DATA);
  FreeLibrary(hLib);
//	fcntl(0, F_SETFL, tem);
  //ioperm(LP_DATA, 3, 0);
  fclose(image);
  perror("\nExit by user...\n");
  exit(1);
}

void upload_byte(char data) {
  char mosi,c;
  int  i,n;
  for (i=1;i<=8;i++) {
    mosi=0;
    if (data & 0x80) mosi=MOSI;
    outb(MASK|SCK|mosi,LP_DATA);
    outb(MASK|0  |mosi,LP_DATA);
  	Sleep(1);
  	while ((inb(LP_STATUS)&MISO)==MISO) {
  		n = read(0, &c, 1);
  		if (n > 0) userexit();
  	}
    outb(MASK|SCK|mosi,LP_DATA);
  	Sleep(1);
  	while ((inb(LP_STATUS)&MISO)==0) {
  		n = read(0, &c, 1);
  		if (n > 0) userexit();
  	}
  	data=data<<1;
  }
}

int main(int argc,char** argv) {

  printf("Shoorick's AT89S52 board loader V 1.0\n");
  if (argc<2) {
    printf("Usage: sz52lpt <image_to_load>\n");
    exit (1);
  }

  image=fopen(argv[1],"rb");
  if (!image) {
    perror("Error opening file!\n");
    exit(1);
  }

  fseek(image,0,SEEK_END);
  fsize=ftell(image);
  fseek(image,0,SEEK_SET);
  printf("Image size: %d bytes\n",fsize);

  hLib = LoadLibrary("inpout32.dll");
  if (!hLib) {printf("Error loading inpout32.dll.\n");exit(1);}

  Inp32 = (INP32) GetProcAddress(hLib,"Inp32");
  Out32 = (OUT32) GetProcAddress(hLib,"Out32");
  if (!(Inp32&&Out32)) {printf("Failed getting Inp32/Out32 functions.\n");exit(1);}

	//set permissions to access port
//	if (ioperm(LP_DATA, 3, 1)) {perror("ioperm"); exit(1);}

  /*outb(0, LP_DATA);
  Sleep(1000);
  outb(255, LP_DATA);
  Sleep(1000);*/
  printf("Handshake...\n");
  syncbit(0);
  syncbit(0);
  syncbit(0);

  syncbit(1);
  syncbit(1);
  syncbit(1);
  syncbit(0);
  syncbit(0);
  syncbit(1);
  syncbit(1);
  syncbit(0);

//	printf("\nHit any key to stop\n");

//	tem=fcntl(0, F_GETFL, 0);
//	fcntl (0, F_SETFL, (tem | O_NDELAY));

  upload_byte(fsize&255);
  upload_byte(((fsize>>8)&255));

  printf("Uploading data...\n");

  while (fsize) {
    if(!fread(&readb,1,1,image)) {
       perror("Error reading file!\n");
       break;
       }
    upload_byte(readb);
    if (!(fsize % 10)) printf("%d bytes\n",fsize);
    fsize--;
  }

  printf("Done...\n");

//	fcntl(0, F_SETFL, tem);
	outb(255, LP_DATA);

  fclose(image);

	//take away permissions to access port
	//if (ioperm(LP_DATA, 3, 0)) {perror("ioperm"); exit(1);}

  FreeLibrary(hLib);
  exit(0);
}

