#include <stdio.h>
#include <fcntl.h>
#include <termios.h>
#include <unistd.h>
#include <error.h>

int main(int argc, char* argv[])
{
	printf("Shoorick's 89S52 board serial loader V 1.0\n");
	if (argc<3) {
		printf("Usage: sz52com </dev/tty?> <file_to_upload>\n");
		return 1;
	}

	FILE* image;
	int fsize=0;

	image=fopen(argv[2],"r");
	if (!image) {
		printf("Error opening %s for reading!\n",argv[2]);
		return 1;
	}

	fseek(image,0,SEEK_END);
	fsize=ftell(image);
	fseek(image,0,SEEK_SET);

	printf("Image size %i bytes...\n",fsize);

	struct termios SerialPortSettings;
	int ftd;

	ftd=open(argv[1],O_RDWR | O_NOCTTY );
	if (ftd==1) {
		printf("Error opening %s as serial port!\n",argv[1]);
		fclose(image);
		return 1;
	}
	else
		printf("Uploading header...\n");

	tcgetattr(ftd,&SerialPortSettings);

	cfsetispeed(&SerialPortSettings,B9600);
	cfsetospeed(&SerialPortSettings,B9600);

	SerialPortSettings.c_cflag &= ~CSIZE;
	SerialPortSettings.c_cflag |= CS8;
	SerialPortSettings.c_cflag &= ~PARENB;
	SerialPortSettings.c_cflag &= ~CSTOPB;
	SerialPortSettings.c_iflag &= ~( IXON | IXOFF | IXANY );
	SerialPortSettings.c_iflag &= ~( ICANON | ECHO | ECHOE | ISIG );
	SerialPortSettings.c_oflag &= ~ONLCR;

	cfmakeraw(&SerialPortSettings);

	tcsetattr(ftd,TCSANOW,&SerialPortSettings);


	char buffer[5];
	int bytes_written = 0;

	buffer[0]=0x00;
	buffer[1]=0x00;
	buffer[2]=0xE6;
	buffer[3]=fsize & 0xFF;
	buffer[4]=(fsize >> 8) & 0xFF;

	bytes_written = write(ftd,buffer,5);

	printf("Uploading data...\n");

	while (fsize) {
		bytes_written = fread(&buffer[4],1,1,image);
		bytes_written = write(ftd,&buffer[4],1);
		fsize--;
	}

	fclose(image);
	close(ftd);
	return 0;
}

