;=======================================================================
;    - 24
;=======================================================================
include "hex.inc"
include "8051x.inc"
include "listing.inc"
;=======================================================================
LED  equ P3.7
BUT  equ P2.7
;-----------------------------------------------------------------------
RAM_START = 2000h
;-----------------------------------------------------------------------
;    org RAM_START
;-----------------------------------------------------------------------
    org  0
    jmp  start
;-----------------------------------------------------------------------
    orgx 03h ; INT0
    ljmp $+RAM_START
;-----------------------------------------------------------------------
    orgx 0Bh ; TF0
    ljmp $+RAM_START
;-----------------------------------------------------------------------
    orgx 13h ; INT1
    ljmp $+RAM_START
;-----------------------------------------------------------------------
    orgx 1Bh ; TF1
    ljmp $+RAM_START
;-----------------------------------------------------------------------
    orgx 23h ; TI & RI
    ljmp $+RAM_START
;-----------------------------------------------------------------------
    orgx 2Bh ; TF2 & EXF2
    ljmp $+RAM_START
;=======================================================================
;
;=======================================================================
;   9600;Flow control=None;Implicit CR on LF;
;   
;=======================================================================
;
;=======================================================================
;orgx RAM_START+1024
;-----------------------------------------------------------------------
start:
    jnb  BUT,run
    mov  DPTR,#RAM_START
    mov  SCON,#50h
    mov  TH1,#0F3h
    mov  TMOD,#20h
    orl  PCON,#80h
    setb TR1
    setb LED
    clr  TI
    clr  RI
sync:
    call read_byte
    jnz  sync
.zero:
    call read_byte
    jz   .zero
    cjne A,#0E6h,sync
;-----------------------------------------------------------------------
    clr  LED
;-----------------------------------------------------------------------
    call read_byte
    mov   R6,A
    call read_byte
    mov   R7,A
    inc   R7
    orl   A,R6
    jz    e0000
;-----------------------------------------------------------------------
loading:
    call read_byte
    movx @DPTR,A
    inc  DPTR
    djnz R6,loading 
    djnz R7,loading
;-----------------------------------------------------------------------
    clr  SCON
    clr  TMOD
    clr  TCON
    clr  TH1
    clr  TL1
    mov  PCON,#10h
;-----------------------------------------------------------------------
blink:
    cpl  LED
delay:
    djnz R6,delay
    djnz R7,delay
    jb   BUT,blink
    setb LED
run:
    ljmp RAM_START
;-----------------------------------------------------------------------
e0000:
    clr  LED
.on:
    djnz R6,.on
    djnz R7,.on
    setb LED
    mov  R5,#7
.off:
    djnz R6,.off
    djnz R7,.off
    djnz R5,.off
    sjmp e0000
;-----------------------------------------------------------------------
read_byte:
    jnb  RI,$
    mov  A,SBUF
    clr  RI
    ret
;=======================================================================
        
        
        
        