;========================================================================
;   1-wire AVR   ;  R0, R1
;=======================================================================
    .equ PORT1W  = PORTA
    .equ PIN1W   = PINA
    .equ DDR1W   = DDRA
    .equ P1W     = PA1
;========================================================================
reset1w: ;      P1W 
;-----------------------------------------------------------------------
    set
    cbi  PORT1W,P1W
    sbi  DDR1W,P1W
    ldi  R16,48 ; ~480 us
    rcall delay1w
    in   R0,SREG
    cli  
    cbi  DDR1W,P1W
    ldi  R16,7 ; ~70 us
    rcall delay1w
    sbis PIN1W,P1W
    clt
    ldi  R16,41 ; ~410 us
    rcall delay1w
    sbis PIN1W,P1W
    set
    bld  R0,SREG_T
    out  SREG,R0
    ret    
;=======================================================================
write1w:    ;  R18    P1W
;-----------------------------------------------------------------------
    in   R0,SREG
    cli  
    ldi R17,8
write1w_loop:
    sbi DDR1W,P1W
    nop
    sbrc R18,0
    cbi DDR1W,P1W
    ldi  R16,6 ; ~60 us
    rcall delay1w
    cbi DDR1W,P1W
    lsr  R18
    dec  R17
    brne write1w_loop    
    out  SREG,R0
    ret
;=======================================================================
read1w:     ;    1W  R18
;-----------------------------------------------------------------------
    in   R0,SREG
    cli  
    ldi R17,8
read1w_loop:
    sbi DDR1W,P1W
    clc
    cbi DDR1W,P1W
    ldi  R16,1 ; ~12 us
    rcall delay1w
    sbic PIN1W,P1W
    sec
    ror R18
    ldi  R16,5 ; ~50 us
    rcall delay1w
    dec  R17
    brne read1w_loop
    out  SREG,R0
read1w_ret:
    ret 
;=======================================================================
delay1w:    ;     x 10  R16 
;-----------------------------------------------------------------------
    mov R1,R16
delay1w_mloop:
    ldi R16, XTAL/300000
delay1w_loop:
    dec R16             ; 1
    brne delay1w_loop   ; 2
    dec R1
    brne delay1w_mloop
    ret        
;=======================================================================
