;=======================================================================
.include "tn2313def.inc"
.include "ds18b20def.inc"
;-----------------------------------------------------------------------
.equ    XTAL = 8000000
.equ    BAUD = 9600
.equ    UBRR_VAL = XTAL/(BAUD*16) - 1
;=======================================================================
.dseg
 .db 0,0,0,0,0,0
numpad:
 .db 0
;-----------------------------------------------------------------------
.cseg
.org 0x00
;=======================================================================
    rjmp start ; Reset Handler
    rjmp 0x00 ; External Interrupt0 Handler
    rjmp 0x00 ; External Interrupt1 Handler
    rjmp 0x00 ; Timer1 Capture Handler
    rjmp 0x00 ; Timer1 CompareA Handler
    rjmp 0x00 ; Timer1 Overflow Handler
    reti ; Timer0 Overflow Handler
    rjmp usart_rx ; USART0 RX Complete Handler
    rjmp 0x00 ; USART0,UDR Empty Handler
    rjmp 0x00 ; USART0 TX Complete Handler
    rjmp 0x00 ; Analog Comparator Handler
    rjmp 0x00 ; Pin Change Interrupt
    rjmp 0x00 ; Timer1 Compare B Handler
    rjmp 0x00 ; Timer0 Compare A Handler
    rjmp 0x00 ; Timer0 Compare B Handler
    rjmp 0x00 ; USI Start Handler
    rjmp 0x00 ; USI Overflow Handler
    rjmp 0x00 ; EEPROM Ready Handler
    rjmp 0x00 ; Watchdog Overflow Handler
;=======================================================================
    .include "1-wire.inc"
    .include "ds18b20.inc"
;-----------------------------------------------------------------------
    .def    rmp = R16
    .def    rBin1L = R18
    .def    rBin1H = R19
    .def    rBin2L = R20
    .def    rBin2H = R21
    .include "CONVERT.inc"
;=======================================================================
start:
    ldi R16,RAMEND
    out SPL,R16
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    rcall get_therm
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    ldi R17,high(UBRR_VAL)
    ldi R16, low(UBRR_VAL)
    out UBRRH,R17
    out UBRRL,R16
    clr R16
    out UCSRA,R16
    ldi R16,(1<<RXEN)|(1<<TXEN)|(1<<RXCIE)
    out UCSRB,R16
    ldi R16,(1<<UCSZ0)|(1<<UCSZ1)
    out UCSRC,R16
;=======================================================================
    sei
;-----------------------------------------------------------------------
mainloop:
        
    rjmp mainloop
;=======================================================================
;
;=======================================================================
cmd_process:
    cpi  R16,0x0D
    breq cmd_done
    cpi  R16,0x0A
    breq cmd_done
    cpi  R16,'T'
    brne cmd_fail
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
    rcall get_therm
    brts cmd_fail
    clr  rBin1H
    sbrs rBin1L,7
    rjmp cmd_t_ready
    neg  rBin1L
    ldi  R16,'-'
    rcall usart_tx
cmd_t_ready:    
    ldi  ZH,high(numpad)
    ldi  ZL, low(numpad)
    rcall Bin2ToAsc
    mov R17,rBin2L
cmd_send_t:
    ld  R16,Z+
    rcall usart_tx
    dec R17
    brne cmd_send_t
    rjmp cmd_ok
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
cmd_fail:
    ldi  R16,'?'
    rcall usart_tx
cmd_ok:
    ldi  R16,0x0D
    rcall usart_tx     
    ldi  R16,0x0A
    rcall usart_tx     
cmd_done:
    ret
;=======================================================================
usart_rx:
    sbis    UCSRA,RXC
    rjmp    usart_rx
    in      R16,UDR
    rcall   cmd_process	
    reti
;=======================================================================
usart_tx:
    sbis    UCSRA,UDRE
    rjmp    usart_tx
    out     UDR,R16
    ret
;=======================================================================
            