.next:

;-----------------------------------------------------------------------
;    mov  DELAY,#50
@@:
    mov  A,KEYS
    cpl  A
    jz   .wait
    mov  A,DELAY
    jnz  @B
;-----------------------------------------------------------------------
.wait:
    mov  R1,#12
.loop:
    mov  DELAY,#50
@@:    
    jb   ENC,.encoderx
    mov  A,KEYS
    cpl  A
    jnz  .key  
    mov  A,DELAY
    jnz  @B
;-----------------------------------------------------------------------
    dec  R1
    mov  A,R1
    jz   .idle
    rrc  A
    mov  A,#DOT
    jnc  @F
    clr  A
@@:    
    mov  R0,POSM
    orl  A,@R0
    mov  B,POS
    call show_sym
    jmp  .loop
;-----------------------------------------------------------------------
.encoderx:
    jmp  .encoder    
;-----------------------------------------------------------------------
.key:
    mov  R1,A
    mov  R0,POSM
    mov  A,@R0
    mov  B,POS
    call show_sym
    mov  KEYDELAY,#50
    mov  A,R1
    rrc  A
    jc   .right
    rrc  A
    jc   .down
    rrc  A
    jc   .up
    rrc  A
    jc   .left
    jmp  .wait
;-----------------------------------------------------------------------
.right:
    mov  A,POS
    jz   .next     
    inc  POSM
    dec  POS
    dec  A
    call delta
    mov  R0,#DELTA
    call store32
    jmp  .next
;-----------------------------------------------------------------------
.left:        
    mov  A,POS
    cjne A,#6,@F
    jmp  .next 
@@:       
    dec  POSM
    inc  POS
    inc  A
    call delta
    mov  R0,#DELTA
    call store32
    jmp  .next
;-----------------------------------------------------------------------
.up:
    call freq_up
    mov  A,KEYDELAY
    mov  DELAY,A
@@:
    mov  A,KEYS
    cpl  A
    jz   @F
    mov  A,DELAY
    jnz  @B
    mov  KEYDELAY,#30
    jmp  .up
@@:    
    jmp  .next
;-----------------------------------------------------------------------
.down:
    call freq_down
    mov  A,KEYDELAY
    mov  DELAY,A
@@:
    mov  A,KEYS
    cpl  A
    jz   @F
    mov  A,DELAY
    jnz  @B
    mov  KEYDELAY,#30
    jmp  .down
@@:    
    jmp  .next
;-----------------------------------------------------------------------
.encoder:
    clr  ENC
    jnb  ENCD,@F
    call freq_up
    jmp  .idle
@@:
    call freq_down
    jmp  .idle
;-----------------------------------------------------------------------
freq_up:
    mov  R0,#FREQ
    call load32
    mov  R0,#DELTA
    call add32
    mov  R0,#FREQMAX
    call cmp32
    jc   freq_set
    mov  R0,#FREQMAX
    call load32
    jmp  freq_set
;-----------------------------------------------------------------------
freq_down:    
    mov  R0,#FREQ
    call load32
    mov  R0,#DELTA
    call sub32
    rlc  A
    jc   .enmin
    call tst32
    jnz  freq_set
.enmin:  
    CONST32 0
;-----------------------------------------------------------------------
freq_set:
    mov  R0,#FREQ
    call store32        
    jmp  show_num
;-----------------------------------------------------------------------
show_num:
    call blankbuff
    mov  R0,#BUFFER+9
    call u2a
    call buff2led
    mov  R0,#NUMS
    jmp  show_row
;-----------------------------------------------------------------------
buff2led:
    mov  R0,#BUFFER-1
.loop:    
    inc  R0
    mov  A,@R0
    jz   .done
    mov  @R0,#DIG_X
    cjne A,#" ",.convert
    jmp  .loop
.convert:
    add  A,#-30h
    call num2led
    mov  @R0,A
    jmp  .loop
.done:
    ret    
;=======================================================================
    
