;=======================================================================
;    - 24
;-----------------------------------------------------------------------
; P1: LED DISPLAY, 4 BUTTONS & SWITCH
; BANK0 & TIMER0 are using by rtc 
;=======================================================================
;include "hex.inc"
include "8051x.inc"
include "@@.inc"
include "7seg.inc"
include "listing.inc"
;=======================================================================
;LED  equ P3.7
;BUT  equ P2.7
;-----------------------------------------------------------------------
FLAG ENC
FLAG ENCD
FLAG FLEFT
FLAG DISPON
FLAG SOUNDON
DATA TIME
DATA TIMER
DATA TIMEL
DATA SECONDS
DATA DELAY
;-----------------------------------------------------------------------
CRIGHT equ P1.7
CLEFT  equ P3.7
SOUND  equ P3.5
BUTTON equ P3.4
LED    equ P3.0
;-----------------------------------------------------------------------
RAM_START = 0; 2000h
;-----------------------------------------------------------------------
    org RAM_START
;-----------------------------------------------------------------------
    jmp start
;-----------------------------------------------------------------------
    orgx 0003h+RAM_START,-1 ; INT0
    clr  EX0
    jmp encoder
;-----------------------------------------------------------------------
    orgx 000Bh+RAM_START,-1 ; TF0
    jmp scan
;-----------------------------------------------------------------------
;    orgx 0013h+RAM_START,-1 ; INT1
;    reti
;-----------------------------------------------------------------------
;    orgx 001Bh+RAM_START,-1 ; TF1
;    reti    
;-----------------------------------------------------------------------
;    orgx 0023h+RAM_START,-1 ; TI & RI
;    reti
;-----------------------------------------------------------------------
;    orgx 002Bh+RAM_START,-1 ; TF2 & EXF2
;    reti
;=======================================================================
;
;=======================================================================
;   1 ms : 2000 ticks @ 24 MHz : 24000000 / ( 12 * 1000 )
;-----------------------------------------------------------------------
;ONE_MS = -2000 + 11 ; 11 ticks between stop and start timer 0 again
ONE_MS = -1000 + 11 ; @ 12 MHz
;-----------------------------------------------------------------------
;   R3 - ms counter
;-----------------------------------------------------------------------
scan:
;-----------------------------------------------------------------------
    clr  TR0
;-----------------------------------------------------------------------
    push PSW                     ; 2
    push ACC                     ; 2
;-----------------------------------------------------------------------
    mov  A,TL0                   ; 1
    add  A,#255 and ONE_MS       ; 1
    mov  TL0,A                   ; 1
    mov  A,TH0                   ; 1
    addc A,#255 and ONE_MS shr 8 ; 1
    mov  TH0,A                   ; 1
;-----------------------------------------------------------------------
    setb TR0                     ; 1
;-----------------------------------------------------------------------
    SELECT_BANK 0
;-----------------------------------------------------------------------
    jnb  SOUNDON,.nosound
    cpl  SOUND ; 1 kHz sound
.nosound:
    setb CLEFT
    setb CRIGHT
    jnb  DISPON,.show_done
    cpl  FLEFT
    mov  A,TIMEL ; left digit
    jnb  FLEFT,.show
    mov  A,TIMER ; right digit
.show:
    mov  P1,A
    mov  C,FLEFT
    mov  CLEFT,C
    cpl  C
    mov  CRIGHT,C
.show_done:    
;-----------------------------------------------------------------------
    djnz R3,.scan_ok
    mov  R3,#10
    mov  A,DELAY
    jz   .scan_ok
    dec  DELAY
;-----------------------------------------------------------------------
.scan_ok:
;-----------------------------------------------------------------------
    mov  C,INT0
    mov  EX0,C
;-----------------------------------------------------------------------
    pop  ACC
    pop  PSW
;-----------------------------------------------------------------------
    reti
;-----------------------------------------------------------------------
encoder:
    setb ENC
    mov  C,INT1
    mov  ENCD,C
    reti
;=======================================================================
;
;=======================================================================
show_time:
    mov  A,TIME
    mov  B,#10
    div  AB
    call num2led
    mov  TIMEL,A
    xch  A,B
    call num2led
    mov  TIMER,A
    ret
;-----------------------------------------------------------------------
num2led: ; A = 0..15 -> A = 7 segment LED combination
    anl  A,#0Fh
    inc  A
    movc A,@A+PC
    ret
    db DIG_0,DIG_1,DIG_2,DIG_3,DIG_4,DIG_5,DIG_6,DIG_7    
    db DIG_8,DIG_9,DIG_A,DIG_B,DIG_C,DIG_D,DIG_E,DIG_F    
;-----------------------------------------------------------------------
start:
;-----------------------------------------------------------------------
    mov  TIME,#10
    call show_time
;-----------------------------------------------------------------------
    SELECT_BANK 0
    mov  SP,#STACK
;-----------------------------------------------------------------------
    mov  R3,#1
;-----------------------------------------------------------------------
    mov  TH0,#-1
    mov  TL0,#-1
;-----------------------------------------------------------------------
    mov  TMOD,#00010001b
    setb ET0
    setb EA
    setb TR0
;-----------------------------------------------------------------------
    SELECT_BANK 1
;-----------------------------------------------------------------------
.idle:
    clr  SOUNDON
    setb LED
    setb DISPON
    jb   ENC,.encoder
    jnb  BUTTON,.timer
    jmp  .idle
;-----------------------------------------------------------------------
.timer:
    clr  LED
    mov  A,TIME
    jz   .alarm
    mov  SECONDS,#60
.second:
    mov  DELAY,#100
    setb DISPON
.wait:
    mov  A,DELAY
    jz   .next
    add  A,#255-10
    mov  DISPON,C    
    jmp  .wait
.next:    
    jnb  BUTTON,.pause
    djnz SECONDS,.second
    call time_down
    jmp  .timer  
;-----------------------------------------------------------------------
.pause:
    setb LED
    clr  DISPON
    jnb  BUTTON,.pause
    mov  DELAY,#10
.pause_w:
    mov  A,DELAY
    jnz  .pause_w
    jnb  BUTTON,.pause
    jmp  .idle              
;-----------------------------------------------------------------------
.alarm:
    setb LED
    mov  DELAY,#50
    setb SOUNDON
    clr  DISPON
.alarm1:    
    jnb  BUTTON,.pause
    mov  A,DELAY
    jnz  .alarm1
    mov  DELAY,#50
    clr  SOUNDON
    setb DISPON
.alarm2:    
    jnb  BUTTON,.pause
    mov  A,DELAY
    jnz  .alarm2
    jmp  .alarm
;-----------------------------------------------------------------------
.encoder:
    clr  ENC
    jnb  ENCD,@F
    call time_up
    jmp  .idle
@@:
    call time_down
    jmp  .idle
;-----------------------------------------------------------------------
time_up:
    mov  A,TIME
    add  A,#-99
    jz   .done
    inc  TIME
.done:
    jmp  show_time
;-----------------------------------------------------------------------
time_down:
    mov  A,TIME
    jz   .done
    dec  TIME
.done:
    jmp  show_time
;-----------------------------------------------------------------------
    
    